<?php 

//http://www.codeeclipse.com/

	error_reporting (E_ALL ^ E_NOTICE); 
	header('Content-type: text/plain; charset=ISO-8859-7');


$Command = $_REQUEST["Command"];
$Invoice = $_REQUEST["Invoice"];
$Suffix = $_REQUEST["Suffix"];

$Fmu1_RequestDirectory = "";
$Fmu1_AnswerDirectory = "";
$Fmu1_InvoiceDirectory = "";
$Fmu1_Request = "";
$Fmu1_Answer = "";
$Fmu1_InvoiceName = "";



	#######################################################
	############  Get Settings from ini file  #############
	#######################################################
	$settings_ini_file="settings.ini" ;

	if (file_exists($settings_ini_file) && is_readable($settings_ini_file)){

		$settings=parse_ini_file("settings.ini");
		$Fmu_Type = $settings["Fmu_Type"];
		$MaxWaitTile = $settings["MaxWaitTile"];

		$Fmu0_RequestDirectory = $settings["RequestDirectory"];
		$Fmu0_AnswerDirectory = $settings["AnswerDirectory"];
		$Fmu0_Request_Ext = $settings["Request_Ext"];
		$Fmu0_Answer_Ext = $settings["Answer_Ext"];

		$FiscalConfigFile=$settings["FiscalConfigFile"];

	}else{
		die("Error: 001 - Cannot open settings ini file: " . $settings_ini_file . ".");
	}
	##########################################################################################################################################





	#################################################################
	########  Load Configuration File for Fmu_type==>2   ############
	#################################################################
	if($Fmu_Type=="2"){
		if(!file_exists($FiscalConfigFile)) exit('Error: 002 - Failed to open Fiscal Config File: ' . $FiscalConfigFile . ".");

		$xml = simplexml_load_file($FiscalConfigFile);
		
		foreach($xml->children()->children() as $child){
			
			$arr = $child->attributes();
			
			if($arr["name"]=="Fmu1_RequestDirectory") $Fmu1_RequestDirectory = $child;
			if($arr["name"]=="Fmu1_AnswerDirectory") $Fmu1_AnswerDirectory = $child;
			if($arr["name"]=="Fmu1_InvoiceDirectory") $Fmu1_InvoiceDirectory = $child;
			
			if($arr["name"]=="Fmu1_Request") $Fmu1_Request = $child;
			if($arr["name"]=="Fmu1_Answer") $Fmu1_Answer = $child;
			if($arr["name"]=="Fmu1_InvoiceName") $Fmu1_InvoiceName = $child;
			
		}
	}
	##########################################################################################################################################
	



	##############################################
	############  Check Variables    #############
	##############################################
	if($Command==""){
		exit("Error: 003 - Empty Command variable.");
	}else{
		if($Command=="I"){
			if($Invoice=="") exit("Error: 004 - Empty Invoice variable.");
		}else if($Command=="?" || $Command=="Z" || $Command=="X"){
			if($Fmu_Type=="1")  exit("Error: 005 - Cannot accept any other commands when type of Fmu is 1.");
		}else{
			exit("Error: 006 - incorrect Command format.");
		}
		
	}
	
	if($Fmu_Type==""){
		exit("Error: 007 - Empty Fmu_Type variable.");
	}else{
		if($Fmu_Type=="1"){
			if($Fmu0_RequestDirectory=="") exit("Error: 008 - Empty Fmu0_RequestDirectory variable.");
			if($Fmu0_AnswerDirectory=="") exit("Error: 009 - Empty Fmu0_AnswerDirectory variable.");
			if($Fmu0_Request_Ext=="") exit("Error: 010 - Empty Fmu0_Request_Ext variable.");
			if($Fmu0_Answer_Ext=="") exit("Error: 011 - Empty Fmu0_Answer_Ext variable.");
			if($Suffix=="") exit("Error: 012 - Empty Suffix variable.");
		}else if($Fmu_Type=="2"){
			if($Fmu1_RequestDirectory=="") exit("Error: 013 - Empty Fmu1_RequestDirectory variable.");
			if($Fmu1_AnswerDirectory=="") exit("Error: 014 - Empty Fmu1_AnswerDirectory variable.");
			if($Fmu1_InvoiceDirectory=="") exit("Error: 015 - Empty Fmu1_InvoiceDirectory variable.");
			if($Fmu1_Request=="") exit("Error: 016 - Empty Fmu1_Request variable.");
			if($Fmu1_Answer=="") exit("Error: 017 - Empty Fmu1_Answer variable.");
			if($Fmu1_InvoiceName=="") exit("Error: 018 - Empty Fmu1_InvoiceName variable.");		
		}else{
			exit("Error: 019 - incorrect Fmu_Type format.");
		}
	}
	##########################################################################################################################################




	
	###############################################
	############  Set File Variables  #############
	###############################################
	if($Fmu_Type=="1"){
		
		$Request_filename = $Fmu0_RequestDirectory . "/" . $Suffix . "." . $Fmu0_Request_Ext;
		$Answer_filename = $Fmu0_AnswerDirectory . "/" . $Suffix . "." . $Fmu0_Answer_Ext;
		
	}else{
		
		if($Suffix=="") $Suffix = random_num();
		$Request_filename = $Fmu1_RequestDirectory . "/" . $Fmu1_Request . "001." . $Suffix;
		$Answer_filename = $Fmu1_AnswerDirectory . "/" . $Fmu1_Answer . "001." . $Suffix;
		$Invoice_filename = $Fmu1_InvoiceDirectory . "/" . $Fmu1_InvoiceName . "001." . $Suffix;
	}
	##########################################################################################################################################
	
	
	
	
	
	
	
	
	
	
	##############################################
	###########  Save Request File    ############
	##############################################
	if(file_exists($Request_filename)) unlink($Request_filename);				### Clean up old Request File
	
	if($Command=="I" && $Fmu_Type=="2"){										### Clean up old Invoice File
		if(file_exists($Invoice_filename)) unlink($Invoice_filename);
	}
	
	
	if(!file_exists($Answer_filename)){
		
		
		if($Fmu_Type=="1"){ # DC STAR 10
			
			$handle = fopen($Request_filename , "w");
			$fwrite = fwrite($handle, iconv("UTF-8", "ISO-8859-7", $Invoice));
			fclose($handle);
			
		}else{ 	# DataSign
			
			if($Command=="I"){
				$handle2 = fopen($Invoice_filename , "w");
				$fwrite = fwrite($handle2, iconv("UTF-8", "ISO-8859-7", $Invoice));
				fclose($handle2);
				
				$Request_Contents = $Command . "\r\n" . $Fmu1_InvoiceName . "001." . $Suffix;
			}else{
				$Request_Contents = $Command;
			}
			
			$handle = fopen($Request_filename , "w");
			$fwrite = fwrite($handle, $Request_Contents);
			fclose($handle);
		}
		
	}
	##########################################################################################################################################
	
	
	
	
	
	##############################################
	#########  Wait for Answer File    ###########
	##############################################
	$StartTime = time();
	while ($MaxWaitTile>=time()-$StartTime){
		
		if (file_exists($Answer_filename)){
			$handle = fopen($Answer_filename, "r");
			if($handle){
				$contents = fread($handle, filesize($Answer_filename));
				fclose($handle);
				unlink($Answer_filename);
				exit ($contents);
			}
			fclose($handle);
			
		}
		
		usleep(100000); // 100ms step
	}
	##########################################################################################################################################
	



	
	
	echo "Error: 020 - fail to communicate with fiscal device";
	
	####### Clean up .....
	if(file_exists($Request_filename)) unlink($Request_filename);
	if(file_exists($Invoice_filename)) unlink($Invoice_filename);


	
	
	##### Helper Functions
	
	function random_num($n=5){
		return rand(0, pow(10, $n));
	}
	
	###########################################################
	
?>